%   Reading pressure and velocities from ADV files 
%   
%   file_name is the name with location from script+name+extension: example:
%   read_outdpm('ADV1\file.dat')
%
%   Version: 25-February-2020
%
%  Uwe Best
% --------------------------------------------------------------------------------------------
clear 
close all

% Codes for plotting
%addpath('D:\PHD\Data Collection Guyana\ADV Software\scripts and manual\scripts ADV\Plotting codes')

% Path of measurements


fileName = {'Guyana_MF901220200220164021'};
Path1    = 'F:\OBS_Calibration\';
Folder   = {'VEC12422_OBS9012_Mudflat\'};
theta    = [240 120 180 135]; % not sure
%epsi     = 210; % angle between structure and north 
alfa     = 0; % angle of x direction ADV with respect to perpendicular to dam
ADV = [1]

% Reading measurements per ADV
for ADV = [1]
    % Writing path per ADV
%     folder = Folder{ADV};
    file_name = 'Guyana_MF901220200220164021';
    Path = strcat(Path1,'VEC12422_OBS9012_Mudflat\');

    fid = fopen(strcat(Path,file_name,'.hdr'),'r');
    Header = textscan(fid,'%s','delimiter','\n');
    
    nl = length(Header{1});
    fclose(fid);

    % Set-up parameters of the deployment
    ADVData.UserSetUp.NumberMeas     = Header{1,1}(3); 
    ADVData.UserSetUp.tStart         = Header{1,1}(7);
    ADVData.UserSetUp.tEnd           = Header{1,1}(8);
    tLine = Header{1,1}(12);
    ADVData.UserSetUp.SampleRate     = str2num(tLine{1}(39:40));
    tLine = Header{1,1}(13);
    ADVData.UserSetUp.VelocityRange  = str2num(tLine{1}(39:42)); 
    tLine = Header{1,1}(14);
    ADVData.UserSetUp.BurstInterval  = str2num(tLine{1}(39:42));
    tLine = Header{1,1}(15);
    ADVData.UserSetUp.SamplesBurst   = str2num(tLine{1}(39:41));
    tLine = Header{1,1}(16);
    ADVData.UserSetUp.SampleVolume   = str2num(tLine{1}(39:41));
    tLine = Header{1,1}(18);
    ADVData.UserSetUp.TransmitLength = str2num(tLine{1}(39:42));
    ADVData.UserSetUp.AnalogInput1   = Header{1,1}(21);
    ADVData.UserSetUp.AnalogInput2   = Header{1,1}(22);
    tLine = Header{1,1}(36);
    B = strsplit(tLine{1},' ');
    ADVData.UserSetUp.Name = B(end); 

    % Instrument serial number
    ii=strcmp(Header{1,1},'Hardware configuration');
    tLine = Header{1,1}(ii);
    B=strsplit(tLine{1},' ');
    ADVData.Instrument.SerialVector = B(end);


    % Time and data properties
    Temp = dlmread(strcat(Path,file_name,'.vhd'));
    [nf, nc] = size(Temp);

    % Writing date per burst
    M       = Temp(:,1);
    D       = Temp(:,2);
    Y       = Temp(:,3);
    H       = Temp(:,4);
    N       = Temp(:,5);
    S       = Temp(:,6);
    ADVData.Burst.BurstCounter = Temp(:,7); 

    figure, plot(Temp(:,18)./1000,'x'), hold on, plot(Temp(:,19)./1000,'x'), hold on, plot(Temp(:,23)./1000,'x'), hold on, plot(Temp(:,24)./1000,'x')
    legend('probe start','svol start','probe end','svol end')
    ylabel('distance to bed (m)')    
    xlabel('measurement points')

    % Distances from probe to the bed
    ADVData.DistProbeBed = Temp(:,18)./1000; 
    ADVData.DistVolBed = Temp(:,19)./1000; 
    ADVData.DistPreSensorBed = Temp(:,18)./1000+0.32;   % Set the distance above the bed here % Doesn't matter here- just calibration of OBS
    
    distances = ADVData.DistPreSensorBed;
    difDistan = ADVData.DistPreSensorBed-mean(ADVData.DistPreSensorBed);
    stdDistan = std(ADVData.DistPreSensorBed);
    I = find(abs(difDistan)>stdDistan);
    
    distances(I) = mean(ADVData.DistPreSensorBed);   
    
    meanDist = mean(distances);
    
    ADVData.MeanDistPreSensorBed = meanDist;
    
    % Bust counter
    ADVData.Burst.BurstCounter = Temp(:,7); 
    ADVData.Burst.BurstCounter = Temp(:,7);    
    
    % Writing the date of each burst
    for ii=1:nf
    ADVData.Burst.FullDate(ii,1) = datetime(Y(ii),M(ii),D(ii),H(ii),N(ii),S(ii));
    end

    %% Pressure and velocity data
    % Reading file
    Data = dlmread(strcat(Path,file_name,'.dat'));
    [nf, nc] = size(Data);

    % Burst counter and ensemble counter
    ADVData.Data.BurstCounter    = Data(:,1); 
    ADVData.Data.EnsembleCounter = Data(:,2);

    % Writing the date for every individual measurement   
    jj = ADVData.Data.BurstCounter;
    Stemp                   = S(jj) +(ADVData.Data.EnsembleCounter-1)/ADVData.UserSetUp.SampleRate;
    ADVData.Data.FullDate   = datetime(Y(jj),M(jj),D(jj),H(jj),N(jj),Stemp);

    % Projecting horizontal velocities
    ADVData.Data.U               = Data(:,3).*cos(alfa(ADV))-Data(:,4).*sin(alfa(ADV));
    ADVData.Data.V               = Data(:,3).*sin(alfa(ADV))+Data(:,4).*cos(alfa(ADV));

    % Vertical velocity 
    ADVData.Data.W               = Data(:,5);
    
    % Other parameters
    ADVData.Data.AmplitudeBeam1  = Data(:,6);
    ADVData.Data.AmplitudeBeam2  = Data(:,7);
    ADVData.Data.AmplitudeBeam3  = Data(:,8);
    ADVData.Data.SNRBeam1        = Data(:,9);
    ADVData.Data.SNRBeam2        = Data(:,10);
    ADVData.Data.SNRBeam3        = Data(:,11); 
    ADVData.Data.CorrelationBeam1= Data(:,12);
    ADVData.Data.CorrelationBeam2= Data(:,13);
    ADVData.Data.CorrelationBeam3= Data(:,14);  

    % Pressure conversion
    ADVData.Data.Pressure        = Data(:,15)*(1/0.980665); % from dbar to m
   
    % Explanation of the units
        % 1 bar = 100 kPa = 100000 Pa
        % 1 mH2O = 9,806.65 pascals (Pa) * 1 bar/100000 Pa
        % 1 mH20 = 0.0980665 bar
        % 1 mH20 = 0.980665 dbar
        % 1 cmH2O= 0.00098067 bar = 0.00980665 dbar

    % Remove pressure offset (0.7 m)
    
    ADVData.Data.Pressure  = ADVData.Data.Pressure; % from dbar to m

    % OBS data
    % Saving voltage reading of the OBS
    ADVData.Data.AnalogueInput1  = Data(:,16);
    ADVData.Data.AnalogueInput2  = Data(:,17);
    
    % Conversion from counts to volts
    ADVData.Data.Volt1  = ADVData.Data.AnalogueInput1*5/65535;
    ADVData.Data.Volt2  = (ADVData.Data.AnalogueInput2.*5)./65535;    
    
    % Conversion from volts to NTU
    ADVData.Data.NTU1  = 2.5920.*(ADVData.Data.Volt1).^2+...
        91.163.*ADVData.Data.Volt1-0.53091;
    
    ADVData.Data.NTU2  = 2.5920.*(ADVData.Data.Volt2).^2+...
        (91.163.*ADVData.Data.Volt2)-0.53091;
    
    % Conversion from NTU to sediment concentration 
    % Order of the ADVs: ADV =[1,2,3,4];
    OBS        = [9012]; % serial number

    %File where the calibration data is stored 
    file_coeff = 'coefficients_fit'; % here you should refer to the calibration with your sediment
    Path_coeff = strcat(Path1,'VEC12422_OBS9012_Mudflat\');%'/Volumes/Seagate Backup Plus Drive/Data fieldwork/Calibration/';
    load(strcat(Path_coeff,file_coeff,'.mat'))

    % Calculating concentration using empirical relationships
    %jj=find(fit3.type ==OBS(ADV));
    
    %ADVData.Data.Concentration1  = polyval(fit3.coeff (:,jj),ADVData.Data.NTU1);
    ADVData.Data.Concentration2(:,1)  = polyval(fit3.coeff(1,:),(ADVData.Data.NTU2(:,1)).');
    

    %% Plots
    % Pressure
%     figure, holdGridBox
%     paperDims(1,1.5)
%     plot(ADVData.Data.FullDate,ADVData.Data.Pressure)
%     xlabel('date')
%     ylabel('Pressure  [mH20]')
%     enhance_plot('times',16)
% 
%     % Velocities
%     figure, paperDims(1,1.5)
%     holdGridBox
%     plot(ADVData.Data.FullDate,ADVData.Data.U,'color',colors(1))
%     plot(ADVData.Data.FullDate,ADVData.Data.V,'color',colors(2))
%     plot(ADVData.Data.FullDate,ADVData.Data.W,'color',colors(3))
%     xlabel('date')
%     ylabel('Velocity  [m/s]')
%     legend('U','V','W')
%     enhance_plot('times',16)

    %% Saving results
    fullname=strcat(Path,file_name,'.mat');
    save(fullname,'ADVData')
end